#ifndef _IndexDir_Cpp
#define _IndexDir_Cpp
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <ShlObj.H>
#include <Stdio.H>
#include <ShlOBJ.H>
#include <Stdlib.H>

#include "NSWFL.H"
#include "Entry.H"
#include "IndexDir.H"
#include "Common.H"

#include "../Dialogs/PackingDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void FilePack::FreeMemory(LPFILEPACKAGE lpFilePackage)
{
    unsigned long LoopCount = 0;

	while(LoopCount < lpFilePackage->FileCount)
    {
		free(lpFilePackage->FileNames[LoopCount]);
		lpFilePackage->FileNames[LoopCount] = NULL;
		LoopCount++;
	}

    lpFilePackage->FileNames = NULL;

    Allocs = 0;
    lpFilePackage->FileCount = 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool FilePack::Initialize(LPFILEPACKAGE lpFilePackage)
{
    lpFilePackage->FileNames = NULL;

    Allocs = 0;
    lpFilePackage->FileCount = 0;

	if((lpFilePackage->FileNames = (char **) calloc(sizeof(char *), AllocIncrement + 1)) == NULL)
    {
        return false;
    }
    
    Allocs = AllocIncrement;

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int MakeRelativeRoot(char *inPath, char *outPath, int inPathLen, int inRootLen)
{
    int RPos = inRootLen;
    int WPos = 0;
    
    while(RPos < inPathLen)
    {
        outPath[WPos] = inPath[RPos];
        RPos++;
        WPos++;
    }

    outPath[WPos] = '\0';

    return WPos;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool FilePack::AddFile(char *inFolder, int RootLen, char *DirTemp, int DirLen, char *File, LPFILEPACKAGE lpFilePackage)
{
	if(lpFilePackage->FileCount == Allocs)
    {
        lpFilePackage->FileNames = (char **) realloc(lpFilePackage->FileNames, ((Allocs * sizeof(char *)) + (AllocIncrement * sizeof(char *))) + 1);
        Allocs = (Allocs + AllocIncrement);
    }

	int NeededMemory = strlen(File) + (DirLen - RootLen) + 10;
	lpFilePackage->FileNames[lpFilePackage->FileCount] = (char *) calloc(NeededMemory, 1);

    MakeRelativeRoot(inFolder, DirTemp, DirLen, RootLen);

	sprintf(lpFilePackage->FileNames[lpFilePackage->FileCount], "%s\\%s", DirTemp, File);

	lpFilePackage->FileCount++;
	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool FilePack::IndexDirectory(char *inFolder, int RootLen, LPFILEPACKAGE lpFilePackage)
{
	WIN32_FIND_DATA FindData;
	HANDLE FileHandle;

	int Found = 0;

	char DirTemp[MAX_PATH];

	DWORD LocalLoop = 0;

	sprintf(DirTemp, "%s\\%s", inFolder, "*.*");
	FileHandle = FindFirstFile(DirTemp,&FindData);
	Found = (int) FileHandle;

    int DirLen = strlen(inFolder);

	while(Found != 0)
	{
		if( strcmp(FindData.cFileName, ".") && strcmp(FindData.cFileName, "..") )
		{
			if(FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
			{
                sprintf(DirTemp, "%s\\%s", inFolder, FindData.cFileName);

                SetStatusFileName(PackingStatusText_hWnd, FindData.cFileName);

                if(!IndexDirectory(DirTemp, RootLen, lpFilePackage))
                {
                    return false;
                }
			}
			else {
				if(!AddFile(inFolder, RootLen, DirTemp, DirLen, FindData.cFileName, lpFilePackage))
				{
					return false;
				}
			}
		}

		Found = FindNextFile(FileHandle, &FindData);
	}
	FindClose(FileHandle);

    if(gdwCurrentJobType == JOB_TYPE_CANCEL)
    {
        return false;
    }

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
